package gov.va.genisis2.model;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * The Class RequestType.
 * 
 * Description: In this RequestType Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 */
@Entity
@Table(name = "RequestType", schema = "dbo")
@XmlRootElement(name = "response")
@JsonIgnoreProperties({ "requests" })
public class RequestType implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = -7137132462197853036L;

	/** The id. */
	private int id;
	
	/** The description. */
	private String description;
	
	/** The Requests */
	private Set<Request> requests = new HashSet<>(0);


	/**
	 * Instantiates a new request type.
	 */
	public RequestType() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new request type.
	 *
	 * @param id the id
	 */
	public RequestType(int id) {
		this.id = id;
	}

	/**
	 * Instantiates a new request type.
	 *
	 * @param id the id
	 * @param description the description
	 * @param requests comment requests
	 */
	public RequestType(int id, String description, Set<Request> requests) {
		this.id = id;
		this.description = description;
		this.requests = requests;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	@Column(name = "Description", length = 50)
	public String getDescription() {
		return this.description;
	}

	/**
	 * Sets the description.
	 *
	 * @param description the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	
	/** Gets Request
	 * @return Returns Request
	 */
	@OneToMany(fetch=FetchType.LAZY, mappedBy="source")
    public Set<Request> getRequests() {
        return this.requests;
    }
    
	/**
	 * Sets the requests
	 *
	 * @param requests the requests
	 * 
	  */
    public void setRequests(Set<Request> requests) {
        this.requests = requests;
    }
}
